<?php

namespace App\Events;

use Pusher\Pusher;

class NotificationEvent
{


    private $pusher;
    private $options = array();  
    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
        $this->options["cluster"] = env("PUSHER_APP_CLUSTER");
        $this->options["useTLS"] = true;
        $this->pusher = new Pusher(
            env("PUSHER_APP_KEY"),
            env("PUSHER_APP_SECRET"),
            env("PUSHER_APP_ID"),
            $this->options
        );
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function trigger($channelName, $eventName, $data){
        $this->pusher->trigger($channelName,$eventName,$data);
    }
}
